using System;
using Server;
using Server.Targeting;
using Server.Mobiles;
using System.Collections;
using Xanthos.Interfaces;

namespace Server.Items
{
    public class GinsengPlant : Item
    {

        [Constructable]
        public GinsengPlant() : base(6380) //6373 nightshade
        {
            Weight = 1.0;
            Stackable = false;
            Name = "ginseng plant";
        }

        public GinsengPlant(Serial serial) : base(serial)
        {
        }
        
        public override void OnDoubleClick(Mobile from)
        {

            if (!IsChildOf(from.Backpack))
            {
                from.SendLocalizedMessage(1042001); // That must be in your pack for you to use it.
            }
            else if (from.InRange(this.GetWorldLocation(), 1))
            {
                this.SendLocalizedMessageTo(from, 1010086);
                from.Target = new GinsengPlantTarget(this);
            }
            else
            {
                from.SendLocalizedMessage(500446); // That is too far away. 
            }
        }
        
    		public override void GetProperties( ObjectPropertyList list )
    		{
    			base.GetProperties( list );
    
            list.Add("+1 to all resistances");
    		}

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);
            writer.Write((int)0);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();
        }
        
        public static bool IsAllowedEvoPet( IEvoCreature evo )
        {
            if ( evo is Xanthos.Evo.EvoHiryu && evo.Stage >= evo.FinalStage )
               return true;
            else
               return false;
        }


        private class GinsengPlantTarget : Target
        {
            private Mobile m_Owner;

            private GinsengPlant m_Plant;

            public GinsengPlantTarget( GinsengPlant plant ) : base(10, false, TargetFlags.None)
            {
                m_Plant = plant;
            }

            protected override void OnTarget( Mobile from, object target )
            {
                if (target is BaseCreature)
                {
                    BaseCreature c = (BaseCreature)target;
                    if (c.Controlled == false)
                        from.SendMessage("Zvire musi byt ochocene.");
                    else if ( c.ControlMaster != from )
                        from.SendMessage("Toto neni tve zvire.");
                    else if ( c.IsDeadPet )
                        from.SendMessage("Nemuzes krmit mrtve zvire.");
                    else if ( c.ControlMaster != from )
                        from.SendMessage("Toto neni tve zvire.");
                    else if ( c is BaseHire )
                        from.SendMessage("Nemuzes krmit najmute pomocniky");
                    else if ( c.Summoned || c is BaseTalismanSummon )
                        from.SendMessage("Nemuzes krmit vyvolane pomocniky.");
                    else if ( c is IEvoCreature && !IsAllowedEvoPet( (IEvoCreature) c ) )
                        from.SendMessage("Toto nemuze snist evolution pet.");
                    else if ( c.Controlled == true && c.ControlMaster == from )
                    {
                        int maxresist = 79;
                        
                        if ( c.PhysicalResistanceSeed > maxresist && c.FireResistSeed > maxresist && c.ColdResistSeed > maxresist
                         && c.PoisonResistSeed > maxresist && c.EnergyResistSeed > maxresist )
                           from.SendMessage("Toto zvire jiz dosahlo vsech maximalnich hodnot resistu.");
                        else
                        {
                           if ( c.PhysicalResistanceSeed <= maxresist ) c.PhysicalResistanceSeed += 1;
                           if ( c.FireResistSeed <= maxresist ) c.FireResistSeed += 1;
                           if ( c.ColdResistSeed <= maxresist ) c.ColdResistSeed += 1;
                           if ( c.PoisonResistSeed <= maxresist ) c.PoisonResistSeed += 1;
                           if ( c.EnergyResistSeed <= maxresist ) c.EnergyResistSeed += 1;
                           
          						if ( c.Body.IsAnimal )
          							c.Animate( 3, 5, 1, true, false, 0 );
          						else if ( c.Body.IsMonster )
          							c.Animate( 17, 5, 1, true, false, 0 );
                           
                           c.PlaySound( Utility.Random( 0x3A, 3 ) );
                           c.FixedParticles( 0x376A, 9, 32, 5008, EffectLayer.Waist );
                           m_Plant.Delete();
                           c.PlaySound( 489 );
                        }
                    }
                     else
                     {
                        from.SendMessage("You cant do that.");
                     }
                }
                else
                {
                    from.SendMessage("Toto muzes snist jen tvoje ochocene zvire.");
                }
            }
        }
    }
}
